<?php
/**
 * LibraryApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

use \Swagger\Client\Configuration;
use \Swagger\Client\ApiClient;
use \Swagger\Client\ApiException;
use \Swagger\Client\ObjectSerializer;

/**
 * LibraryApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class LibraryApi
{

    /**
     * API Client
     *
     * @var \Swagger\Client\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Swagger\Client\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Swagger\Client\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://hub.blended.co/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Swagger\Client\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Swagger\Client\ApiClient $apiClient set the API client
     *
     * @return LibraryApi
     */
    public function setApiClient(\Swagger\Client\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation canonicalSet
     *
     * Get package draft.
     *
     * @param string $account_slug accountSlug (required)
     * @param string $slug package slug used to uniquely identify a package. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\CreateCanonical $body request data used to update package. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function canonicalSet($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->canonicalSetWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation canonicalSetWithHttpInfo
     *
     * Get package draft.
     *
     * @param string $account_slug accountSlug (required)
     * @param string $slug package slug used to uniquely identify a package. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\CreateCanonical $body request data used to update package. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function canonicalSetWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling canonicalSet');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling canonicalSet');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling canonicalSet');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling canonicalSet');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/canonical/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('text/plain'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/canonical/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
