<?php
/**
 * HyperLinkDraft
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * HyperLinkDraft Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HyperLinkDraft implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HyperLinkDraft';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'href' => 'string',
        'pk' => 'int',
        'package' => 'int',
        'draft_name' => 'string',
        'modified_date' => '\DateTime',
        'created_date' => '\DateTime',
        'package_hash' => 'string',
        'user' => 'string',
        'validatorplan' => 'object',
        'documents' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'href' => 'href',
        'pk' => 'pk',
        'package' => 'package',
        'draft_name' => 'draft_name',
        'modified_date' => 'modified_date',
        'created_date' => 'created_date',
        'package_hash' => 'package_hash',
        'user' => 'user',
        'validatorplan' => 'validatorplan',
        'documents' => 'documents'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'href' => 'setHref',
        'pk' => 'setPk',
        'package' => 'setPackage',
        'draft_name' => 'setDraftName',
        'modified_date' => 'setModifiedDate',
        'created_date' => 'setCreatedDate',
        'package_hash' => 'setPackageHash',
        'user' => 'setUser',
        'validatorplan' => 'setValidatorplan',
        'documents' => 'setDocuments'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'href' => 'getHref',
        'pk' => 'getPk',
        'package' => 'getPackage',
        'draft_name' => 'getDraftName',
        'modified_date' => 'getModifiedDate',
        'created_date' => 'getCreatedDate',
        'package_hash' => 'getPackageHash',
        'user' => 'getUser',
        'validatorplan' => 'getValidatorplan',
        'documents' => 'getDocuments'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['href'] = isset($data['href']) ? $data['href'] : null;
        $this->container['pk'] = isset($data['pk']) ? $data['pk'] : null;
        $this->container['package'] = isset($data['package']) ? $data['package'] : null;
        $this->container['draft_name'] = isset($data['draft_name']) ? $data['draft_name'] : null;
        $this->container['modified_date'] = isset($data['modified_date']) ? $data['modified_date'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['package_hash'] = isset($data['package_hash']) ? $data['package_hash'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['validatorplan'] = isset($data['validatorplan']) ? $data['validatorplan'] : null;
        $this->container['documents'] = isset($data['documents']) ? $data['documents'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['href'] === null) {
            $invalid_properties[] = "'href' can't be null";
        }
        if ($this->container['pk'] === null) {
            $invalid_properties[] = "'pk' can't be null";
        }
        if ($this->container['package'] === null) {
            $invalid_properties[] = "'package' can't be null";
        }
        if ($this->container['draft_name'] === null) {
            $invalid_properties[] = "'draft_name' can't be null";
        }
        if ($this->container['modified_date'] === null) {
            $invalid_properties[] = "'modified_date' can't be null";
        }
        if ($this->container['created_date'] === null) {
            $invalid_properties[] = "'created_date' can't be null";
        }
        if ($this->container['package_hash'] === null) {
            $invalid_properties[] = "'package_hash' can't be null";
        }
        if ($this->container['user'] === null) {
            $invalid_properties[] = "'user' can't be null";
        }
        if ($this->container['validatorplan'] === null) {
            $invalid_properties[] = "'validatorplan' can't be null";
        }
        if ($this->container['documents'] === null) {
            $invalid_properties[] = "'documents' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['href'] === null) {
            return false;
        }
        if ($this->container['pk'] === null) {
            return false;
        }
        if ($this->container['package'] === null) {
            return false;
        }
        if ($this->container['draft_name'] === null) {
            return false;
        }
        if ($this->container['modified_date'] === null) {
            return false;
        }
        if ($this->container['created_date'] === null) {
            return false;
        }
        if ($this->container['package_hash'] === null) {
            return false;
        }
        if ($this->container['user'] === null) {
            return false;
        }
        if ($this->container['validatorplan'] === null) {
            return false;
        }
        if ($this->container['documents'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets href
     * @return string
     */
    public function getHref()
    {
        return $this->container['href'];
    }

    /**
     * Sets href
     * @param string $href current object reference url
     * @return $this
     */
    public function setHref($href)
    {
        $this->container['href'] = $href;

        return $this;
    }

    /**
     * Gets pk
     * @return int
     */
    public function getPk()
    {
        return $this->container['pk'];
    }

    /**
     * Sets pk
     * @param int $pk unique identifier of draft.
     * @return $this
     */
    public function setPk($pk)
    {
        $this->container['pk'] = $pk;

        return $this;
    }

    /**
     * Gets package
     * @return int
     */
    public function getPackage()
    {
        return $this->container['package'];
    }

    /**
     * Sets package
     * @param int $package package pk.
     * @return $this
     */
    public function setPackage($package)
    {
        $this->container['package'] = $package;

        return $this;
    }

    /**
     * Gets draft_name
     * @return string
     */
    public function getDraftName()
    {
        return $this->container['draft_name'];
    }

    /**
     * Sets draft_name
     * @param string $draft_name draft name.
     * @return $this
     */
    public function setDraftName($draft_name)
    {
        $this->container['draft_name'] = $draft_name;

        return $this;
    }

    /**
     * Gets modified_date
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     * @param \DateTime $modified_date last modified date.
     * @return $this
     */
    public function setModifiedDate($modified_date)
    {
        $this->container['modified_date'] = $modified_date;

        return $this;
    }

    /**
     * Gets created_date
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param \DateTime $created_date package draft creation date.
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets package_hash
     * @return string
     */
    public function getPackageHash()
    {
        return $this->container['package_hash'];
    }

    /**
     * Sets package_hash
     * @param string $package_hash package hash
     * @return $this
     */
    public function setPackageHash($package_hash)
    {
        $this->container['package_hash'] = $package_hash;

        return $this;
    }

    /**
     * Gets user
     * @return string
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param string $user package draft creator name.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets validatorplan
     * @return object
     */
    public function getValidatorplan()
    {
        return $this->container['validatorplan'];
    }

    /**
     * Sets validatorplan
     * @param object $validatorplan Detail view of rating.
     * @return $this
     */
    public function setValidatorplan($validatorplan)
    {
        $this->container['validatorplan'] = $validatorplan;

        return $this;
    }

    /**
     * Gets documents
     * @return object
     */
    public function getDocuments()
    {
        return $this->container['documents'];
    }

    /**
     * Sets documents
     * @param object $documents Detail view of rating.
     * @return $this
     */
    public function setDocuments($documents)
    {
        $this->container['documents'] = $documents;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


