<?php
/**
 * SearchResult
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * SearchResult Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SearchResult implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SearchResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'href' => 'string',
        'pk' => 'int',
        'name' => 'string',
        'package_type' => 'string',
        'package_status' => 'string',
        'description' => 'string',
        'rating_avg' => 'float',
        'rating_count' => 'float',
        'modified_date' => '\DateTime',
        'created_date' => '\DateTime',
        'user' => 'string',
        'thumbnail_image' => 'string',
        'details_image' => 'string',
        'grid_layout_image' => 'string',
        'block_layout_image' => 'string',
        'licenses' => 'object',
        'ratings' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'href' => 'href',
        'pk' => 'pk',
        'name' => 'name',
        'package_type' => 'package_type',
        'package_status' => 'package_status',
        'description' => 'description',
        'rating_avg' => 'rating_avg',
        'rating_count' => 'rating_count',
        'modified_date' => 'modified_date',
        'created_date' => 'created_date',
        'user' => 'user',
        'thumbnail_image' => 'thumbnail_image',
        'details_image' => 'details_image',
        'grid_layout_image' => 'grid_layout_image',
        'block_layout_image' => 'block_layout_image',
        'licenses' => 'licenses',
        'ratings' => 'ratings'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'href' => 'setHref',
        'pk' => 'setPk',
        'name' => 'setName',
        'package_type' => 'setPackageType',
        'package_status' => 'setPackageStatus',
        'description' => 'setDescription',
        'rating_avg' => 'setRatingAvg',
        'rating_count' => 'setRatingCount',
        'modified_date' => 'setModifiedDate',
        'created_date' => 'setCreatedDate',
        'user' => 'setUser',
        'thumbnail_image' => 'setThumbnailImage',
        'details_image' => 'setDetailsImage',
        'grid_layout_image' => 'setGridLayoutImage',
        'block_layout_image' => 'setBlockLayoutImage',
        'licenses' => 'setLicenses',
        'ratings' => 'setRatings'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'href' => 'getHref',
        'pk' => 'getPk',
        'name' => 'getName',
        'package_type' => 'getPackageType',
        'package_status' => 'getPackageStatus',
        'description' => 'getDescription',
        'rating_avg' => 'getRatingAvg',
        'rating_count' => 'getRatingCount',
        'modified_date' => 'getModifiedDate',
        'created_date' => 'getCreatedDate',
        'user' => 'getUser',
        'thumbnail_image' => 'getThumbnailImage',
        'details_image' => 'getDetailsImage',
        'grid_layout_image' => 'getGridLayoutImage',
        'block_layout_image' => 'getBlockLayoutImage',
        'licenses' => 'getLicenses',
        'ratings' => 'getRatings'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['href'] = isset($data['href']) ? $data['href'] : null;
        $this->container['pk'] = isset($data['pk']) ? $data['pk'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['package_type'] = isset($data['package_type']) ? $data['package_type'] : null;
        $this->container['package_status'] = isset($data['package_status']) ? $data['package_status'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['rating_avg'] = isset($data['rating_avg']) ? $data['rating_avg'] : null;
        $this->container['rating_count'] = isset($data['rating_count']) ? $data['rating_count'] : null;
        $this->container['modified_date'] = isset($data['modified_date']) ? $data['modified_date'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['thumbnail_image'] = isset($data['thumbnail_image']) ? $data['thumbnail_image'] : null;
        $this->container['details_image'] = isset($data['details_image']) ? $data['details_image'] : null;
        $this->container['grid_layout_image'] = isset($data['grid_layout_image']) ? $data['grid_layout_image'] : null;
        $this->container['block_layout_image'] = isset($data['block_layout_image']) ? $data['block_layout_image'] : null;
        $this->container['licenses'] = isset($data['licenses']) ? $data['licenses'] : null;
        $this->container['ratings'] = isset($data['ratings']) ? $data['ratings'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets href
     * @return string
     */
    public function getHref()
    {
        return $this->container['href'];
    }

    /**
     * Sets href
     * @param string $href current object reference url
     * @return $this
     */
    public function setHref($href)
    {
        $this->container['href'] = $href;

        return $this;
    }

    /**
     * Gets pk
     * @return int
     */
    public function getPk()
    {
        return $this->container['pk'];
    }

    /**
     * Sets pk
     * @param int $pk unique identifier of package.
     * @return $this
     */
    public function setPk($pk)
    {
        $this->container['pk'] = $pk;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name package name.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets package_type
     * @return string
     */
    public function getPackageType()
    {
        return $this->container['package_type'];
    }

    /**
     * Sets package_type
     * @param string $package_type package type
     * @return $this
     */
    public function setPackageType($package_type)
    {
        $this->container['package_type'] = $package_type;

        return $this;
    }

    /**
     * Gets package_status
     * @return string
     */
    public function getPackageStatus()
    {
        return $this->container['package_status'];
    }

    /**
     * Sets package_status
     * @param string $package_status package status
     * @return $this
     */
    public function setPackageStatus($package_status)
    {
        $this->container['package_status'] = $package_status;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description package description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets rating_avg
     * @return float
     */
    public function getRatingAvg()
    {
        return $this->container['rating_avg'];
    }

    /**
     * Sets rating_avg
     * @param float $rating_avg average rating.
     * @return $this
     */
    public function setRatingAvg($rating_avg)
    {
        $this->container['rating_avg'] = $rating_avg;

        return $this;
    }

    /**
     * Gets rating_count
     * @return float
     */
    public function getRatingCount()
    {
        return $this->container['rating_count'];
    }

    /**
     * Sets rating_count
     * @param float $rating_count package total rating submitted.
     * @return $this
     */
    public function setRatingCount($rating_count)
    {
        $this->container['rating_count'] = $rating_count;

        return $this;
    }

    /**
     * Gets modified_date
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     * @param \DateTime $modified_date last modified date.
     * @return $this
     */
    public function setModifiedDate($modified_date)
    {
        $this->container['modified_date'] = $modified_date;

        return $this;
    }

    /**
     * Gets created_date
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param \DateTime $created_date account creation date.
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets user
     * @return string
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param string $user package creator name.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets thumbnail_image
     * @return string
     */
    public function getThumbnailImage()
    {
        return $this->container['thumbnail_image'];
    }

    /**
     * Sets thumbnail_image
     * @param string $thumbnail_image 
     * @return $this
     */
    public function setThumbnailImage($thumbnail_image)
    {
        $this->container['thumbnail_image'] = $thumbnail_image;

        return $this;
    }

    /**
     * Gets details_image
     * @return string
     */
    public function getDetailsImage()
    {
        return $this->container['details_image'];
    }

    /**
     * Sets details_image
     * @param string $details_image 
     * @return $this
     */
    public function setDetailsImage($details_image)
    {
        $this->container['details_image'] = $details_image;

        return $this;
    }

    /**
     * Gets grid_layout_image
     * @return string
     */
    public function getGridLayoutImage()
    {
        return $this->container['grid_layout_image'];
    }

    /**
     * Sets grid_layout_image
     * @param string $grid_layout_image 
     * @return $this
     */
    public function setGridLayoutImage($grid_layout_image)
    {
        $this->container['grid_layout_image'] = $grid_layout_image;

        return $this;
    }

    /**
     * Gets block_layout_image
     * @return string
     */
    public function getBlockLayoutImage()
    {
        return $this->container['block_layout_image'];
    }

    /**
     * Sets block_layout_image
     * @param string $block_layout_image 
     * @return $this
     */
    public function setBlockLayoutImage($block_layout_image)
    {
        $this->container['block_layout_image'] = $block_layout_image;

        return $this;
    }

    /**
     * Gets licenses
     * @return object
     */
    public function getLicenses()
    {
        return $this->container['licenses'];
    }

    /**
     * Sets licenses
     * @param object $licenses Package Licenses.
     * @return $this
     */
    public function setLicenses($licenses)
    {
        $this->container['licenses'] = $licenses;

        return $this;
    }

    /**
     * Gets ratings
     * @return object
     */
    public function getRatings()
    {
        return $this->container['ratings'];
    }

    /**
     * Sets ratings
     * @param object $ratings Package ratings.
     * @return $this
     */
    public function setRatings($ratings)
    {
        $this->container['ratings'] = $ratings;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


