<?php

/**
 * Post Types Admin
 *
 * @class    Blended_Admin_Post_Types
 * @author   Blended
 * @category Admin
 * @package  WooCommerce/Admin
 * @version  3.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Blended_Admin_Post_Types class.
 */
class Blended_Admin_Post_Types {

    /**
     * Constructor.
     */
    public function __construct() {

        //Gallery columns
        add_filter('manage_blended_gallery_posts_columns', array($this, 'gallery_columns'));
        add_action('manage_blended_gallery_posts_custom_column', array($this, 'render_gallery_columns'), 2);
    }

    /**
     * Custom columns for gallery
     * @param array $columns
     * @return string
     */
    public function gallery_columns($columns) {

        $columns = array(
            'cb' => '<input type="checkbox">',
            'post_thumb' => 'Thumbnail',
            'title' => 'Title',
            'tag' => 'Tags',
            'gallery_catgory' => 'Categories',
            'date' => 'Date',
        );
        return $columns;
    }

    public function render_gallery_columns($column) {
       global $post;
        switch ($column) {
            case "post_thumb":
                echo the_post_thumbnail('admin-list-thumb');

                break;
            
            case "gallery_catgory":
                $list = get_the_term_list( $post->ID, 'blended_gallery_cat', '', ', ','');
                echo ( $list ? $list : '<span aria-hidden="true">—</span>' );
                break;
            
            case "tag":
                $list =  get_the_term_list( $post->ID, 'blended_gallery_tag', '', ', ','');
                echo ( $list ? $list : '<span aria-hidden="true">—</span>' );
                break;

            default:
                break;
        }
    }

}

new Blended_Admin_Post_Types();
