<?php
/**
 * Blended Admin
 *
 * @class    Blended_Admin
 * @author   Blended
 * @category Admin
 * @package  Blended/Admin
 * @version  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


/**
 * Blended_Admin class.
 */
class Blended_Admin {
	
	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'includes' ) );
		add_action( 'current_screen', array( $this, 'conditional_includes' ) );		
	}
	
	/**
	 * Include admin instances.
	 */
	public function includes() {
		include_once( dirname( __FILE__ ) . '/class-admin-meta-boxes.php' );
		include_once( dirname( __FILE__ ) . '/class-admin-post-types.php' );
	}
	
	/**
	 * Include admin files conditionally.
	 */
	public function conditional_includes() {
		if ( ! $screen = get_current_screen() ) {
			return;
		}

		switch ( $screen->id ) {
			case 'dashboard' :
			break;
			case 'options-permalink' :
			break;
			case 'users' :
			case 'user' :
			case 'profile' :
			case 'user-edit' :
			break;
		}
	}
}

new Blended_Admin();
