<?php

/**
 * Blended WooCommerce Support
 * @since 1.0
 */
// don't load directly
if (!defined('ABSPATH'))
    die('-1');

/**
 *  Blended_WC Class
 */
class Blended_WC {


    public function __construct() {
        // We safely integrate with WC with this hook
        if (!$this->is_wc_active())
            return;
        
        add_action("init", array(&$this, "includes"));
       
    }

    public function includes() {
        
        require_once dirname(__FILE__) ."/woocommerce-helper-functions.php";
    }

    public function include_templates() {
        
    }

    
    /**
     * Check if WooCommerce is active
     */
    public function is_wc_active() {
        if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            return false;
        }
        return true;
    }

}

//Instantiate Blended_WC
new Blended_WC();
