<?php
/* 
 * This file generates the default login form within the booking form (if enabled in options).
 */
?>
<div class="em-booking-login one_half-sm">
	<form class="em-booking-login-form bl-booking-login" action="<?php echo site_url('wp-login.php', 'login_post'); ?>" method="post">
	<div class="eventlogin">
	<p><?php esc_html_e('Log in if you already have an account with us.','events-manager'); ?></p>
    <div class="eventlogin__row--username eventlogin__row">
		<label><?php esc_html_e( 'Username','events-manager') ?></label>
		<input type="text" name="log" class="input" value="" />
	</div>
	<div class="eventlogin__row--password eventlogin__row">
		<label><?php esc_html_e( 'Password','events-manager') ?></label>
		<input type="password" name="pwd" class="input" value="" />
    </div>
    <?php do_action('login_form'); ?>
	
	<div class="row">
		<div class="one_half-sm">
			<div class="remember_password">
				<input name="rememberme" type="checkbox" id="em_rememberme" value="forever" /> <label><?php esc_html_e( 'Remember Me','events-manager') ?></label>
			</div>
		</div>
		<div class="one_half-sm">
			<div class="forgot_password">
				<input type="hidden" name="redirect_to" value="<?php echo esc_url( get_site_url(false, $_SERVER['REQUEST_URI']) ); ?>#em-booking" />
				<?php
				//Signup Links
				if ( get_option('users_can_register') ) {
					echo "<br />";  
					if ( function_exists('bp_get_signup_page') ) { //Buddypress
						$register_link = bp_get_signup_page();
					}elseif ( file_exists( ABSPATH."/wp-signup.php" ) ) { //MU + WP3
						$register_link = site_url('wp-signup.php', 'login');
					} else {
						$register_link = site_url('wp-login.php?action=register', 'login');
					}
					?>
					<a href="<?php echo $register_link ?>"><?php esc_html_e('Sign Up','events-manager') ?></a>&nbsp;&nbsp;|&nbsp;&nbsp; 
					<?php
				}
				?>	                    
				<a href="<?php echo site_url('wp-login.php?action=lostpassword', 'login') ?>" title="<?php esc_html_e('Password Lost and Found', 'events-manager') ?>"><?php esc_html_e('Lost your password?', 'events-manager') ?></a> 
			</div>
		</div>
	</div>
	<div class="login_btn">
		<input type="submit" class="btn btn--radius btn--transparent" name="wp-submit" id="em_wp-submit" value="<?php esc_html_e('Login', 'events-manager'); ?>" tabindex="100" />
	</div>
	</div>
  </form>
</div>