<?php

// Defines blended tags, filters and functions and provide functionality to blended themes.
include dirname(__FILE__) . '/blended-php/blended/Blended_Tags.php';

// Interacts with Hub.
include dirname(__FILE__) . '/hostlib/Controller.php';

// Specific for Blended Image manipulation operations.
include dirname(__FILE__) . '/hostlib/Blended_Image_handling.php';

// Include common mark operations.
include dirname(__FILE__) . '/hostlib/CommonMark.php';

// Path to active theme directory.
$active_dir = $ACTIVE_THEME;

// Stores theme's data.
$context;

class Blended_Loader extends TimberSite
{
    function __construct()
    {
        $this->preview_dir = '';
        add_theme_support('post-thumbnails');
        add_theme_support('menus');
        add_filter('timber_context', array($this, 'add_to_context'));
        /**
         * @deprecated get_twig
         * use timber/twig
         */
        add_filter('timber/twig', array($this, 'add_to_twig'));
        add_action('init', array($this, 'register_post_types'));
        add_action('init', array($this, 'register_taxonomies'));
        add_action('after_switch_theme', array($this, 'blended_initials'));
        parent::__construct();
    }
    
    function add_to_twig($twig)
    {
        /* this is where you can add your own fuctions to twig */
        $twig->addExtension(new Blended_Tags());
        $twig->addExtension(new Twig_Extension_StringLoader());

        // Article functions
        $function = new \Twig_SimpleFunction('get_articles', "blended_articles");
        $twig->addFunction($function);

        $function = new \Twig_SimpleFunction('get_article', "blended_article");
        $twig->addFunction($function);

        // Navigation menu functions
        $function = new \Twig_SimpleFunction('get_nav_menu', "blended_nav_menu");
        $twig->addFunction($function);

        // Function that provides Home URL
        $function = new \Twig_SimpleFunction('home', "blended_home_url");
        $twig->addFunction($function);
        
        
        return $twig;
    }
    
    function set_preview_dir($dir)
    {
        $this->preview_dir = $dir;
    }
    
    function register_post_types()
    {
        // this is where you can register custom post types
    }
    
    function register_taxonomies()
    {
        // this is where you can register custom taxonomies
    }
    
    // Get acquisition package auto intall on theme activate.
    function blended_initials() {
        global $active_dir;
        if (isset($_COOKIE[LOGGED_IN_COOKIE])) {
            $user_session = $_COOKIE[LOGGED_IN_COOKIE];
            $user_id = wp_validate_auth_cookie($user_session, 'logged_in');
        } else {
            $user_id = null;
        }
        $backend = new Backend($active_dir);
        $session = $backend->get_session_key($user_id);
        $network = new Network($session);
        $controller = new Controller($backend, $network);
        $controller->blended_initials();
    }

    /*************************************************************************************************************
    Adding theme object to $context array which will be globally available to get access from twig files
    if $context=Timber::get_context() is used in their respective Controller.
    *************************************************************************************************************/
    
    /* --- Adding data to context , to get availble theme object globally within a site --- */
    function add_to_context($context)
    {
        global $active_dir;
        global $THEME_SETTINGS;
        if ($this->preview_dir) {
            $active_dir = $this->preview_dir;
        }

        $template = array();
        try {
            
            if (isset($_COOKIE[LOGGED_IN_COOKIE])) {
                $user_session = $_COOKIE[LOGGED_IN_COOKIE];
                $user_id      = wp_validate_auth_cookie($user_session, 'logged_in');
            } else {
                $user_id = null;
            }
            $backend    = new Backend($active_dir);
            $session    = $backend->get_session_key($user_id);
            $network    = new Network($session);
            $controller = new Controller($backend, $network);
            
            $theme_slug = $active_dir;

            if(empty($theme_slug))
                wp_die("Oops ! Please activate any blended theme.");
            
            try {
                $project    = $controller->get_package($theme_slug, "context", true);
            } catch (Exception $e) {
                $error = json_decode($e->getMessage(), true); 
                echo $error['message'];
            }

            $context['theme_setting']      = $THEME_SETTINGS->getSection("theme_settings");
            $project['navigation_setting'] = $THEME_SETTINGS->getSection("navigation_settings");
            foreach ($project['navigation_setting'] as $key => $value) {
                $project['navigation_setting'][$key] = json_decode($value, true);
            }
           
            $context['vengine_menu']     = new TimberMenu(4);
            $context['footer']           = new TimberMenu(2);
            $context['theme_two_footer'] = new TimberMenu(5);
            $context['menu'] = new TimberMenu();
            $context['footer_widgets']   = Timber::get_widgets('sidebar-3');
            $context['contact_widgets']  = Timber::get_widgets('sidebar-4');
            $context['sidebar']          = Timber::get_widgets('sidebar-2');
            $context['site']             = (array) $this;
            $context['post']             = new TimberPost();
            $context['user_id']          = $user_id;

            $theme_object                = $project;
            $context['theme']            = $theme_object;
            
            Timber::$locations = dirname(__FILE__) . '/blended_templates';
            
            return $context;
        }
        
        catch (Exception $e) {
            echo "<pre>";
            echo 'Caught exception: (', $e->getMessage(), ')</br>Directory or File does not Exist', ' in file ', $e->getFile(), ' on line ', $e->getLine();
            echo "</pre>";
        }
    }
}

// this will remove paragraph tag from wordpress page/post editor.
//remove_filter('the_content', 'wpautop');
//remove_filter('the_excerpt', 'wpautop');
